<?php

// server response codes
define('SUCCESS', '602');
define('INVALIDTOKEN', '603');
define('NOROWS', '604');
define('ERROR', '605');

// database connection parameters
$db_host = 'localhost:3306';
$db_user = 'intervim_guser';
$db_pass = '*ApIL0K3A!';
$db_name = 'intervim_service_guard';

$db_conn;

function base64url_encode($data) { 
 return \rtrim(\strtr(\base64_encode($data), '+/', '-_'), '=');
}

function Token(){
  $header = [
    'alg' => 'HS256',
    'typ' => 'JWT'
  ];
  $header = json_encode($header);
  $header = base64url_encode($header);

  $payload = [
    'sub' => 'guardOps',
    'name' => 'ServiceGuard'
  ];
  $payload = json_encode($payload);
  $payload = base64url_encode($payload);
  $payload = rtrim($payload, "==");

  $signature = hash_hmac('sha256', "$header.$payload", '674UskkrRTg57@j^nU4K68uC6V2RaR!24zNhF$_CzW4cMFq9TY%HqtDjA82pn4tm6S73dJPwBGvCgF3VS^5wYv9&jQA#s3G9*xppb!!!N257t2Rg3@$c6BPcchHHz894n*9yc529Dc3g5J*jxcaT4sU8p*8k28NSRkH24^Xk67w6fK^fwePEP8D#D$UHGkB6z9SbZAuf4uJ3uB3V7%5@wh65dz*2T6tb6NqD&P55BB6w5f45D2y38t^5R*5*WZtC', true);
  $signature = base64url_encode($signature);

  return "$header.$payload.$signature";
}


function ServerResponse($response_code, $data = '')
{
  LogMessage($response_code);

  if(isset($db_conn) && @mysql_ping($db_conn)){
    @mysql_close($db_conn);
  }

  $msg_sep = "\n";
  
  echo $response_code . $msg_sep . $data;
  die();
}


function ValidateAndGet($var){
  if(isset($_POST[$var]) && trim($_POST[$var]) != ''){
    return trim($_POST[$var]);
  }
  else
  {
    ServerResponse(ERROR);
  }
}

function ValidateObj($obj){
  if(!$obj){
    ServerResponse(ERROR);
  }
}

function LogMessage($msg){

    /*
    $logFile = fopen("guardOps.log", "a") or die("Unable to open the log file!");
    $msg = "[". date("Y/m/d h:i:sa") ."] " . $msg . "\n";
    fwrite($logFile, $msg);
    fclose($logFile); 
    */
  
}

function GetSql($op){

  $code = ValidateAndGet('code');  
  switch ($op) {
    case 'clientExists':
    LogMessage("Validating name");
    $name = ValidateAndGet('name');
    return "SELECT 1 AS validation FROM `client_status` WHERE `client_code`=". $code ." AND `validation_name`='". @mysql_real_escape_string($name) ."' AND `status`<>0";
    break;
    case 'log':
    $macAddress = ValidateAndGet('mac_address');
    $computerName = ValidateAndGet('computer_name');
    $step = ValidateAndGet('step');
    $msg = ValidateAndGet('msg');
    return "INSERT INTO `client_status_log` (`client_code`, `mac_address`, `computer_name`, `step_count`, `message`, `log_date`) VALUES (". $code .", '". @mysql_real_escape_string($macAddress) ."', '". @mysql_real_escape_string($computerName) ."', ". $step .", '". @mysql_real_escape_string($msg) ."', now())";
    break;
    case 'clientInfo':
    return "SELECT `status`, `file_path`, `file_deleted`, `file_not_found`, `current_mac_address`, `current_computer_name` FROM `client_status` WHERE `client_code`=" . $code;
    break;
    case 'changeFilePath':
    $path = ValidateAndGet('path');
    return "UPDATE `client_status` SET `file_path`='". @mysql_real_escape_string($path) ."' WHERE `client_code`=" . $code;
    break;
    case 'fileNotFound':
    return "UPDATE `client_status` SET `file_not_found`=1 WHERE `client_code`=" . $code;
    break;
    case 'fileDeleted':
    return "UPDATE `client_status` SET `file_deleted`=1 WHERE `client_code`=" . $code;
    break;
    case 'changeMachineInfo':
    $mac_address = ValidateAndGet('mac_address');
    $computer_name = ValidateAndGet('computer_name');
    return "UPDATE `client_status` SET `current_mac_address`='".@mysql_real_escape_string($mac_address)."', `current_computer_name`='".@mysql_real_escape_string($computer_name)."' WHERE `client_code`=" . $code;
    break;
    case 'changeComputerName':
    $computer_name = ValidateAndGet('computer_name');
     return "UPDATE `client_status` SET `current_computer_name`='".@mysql_real_escape_string($computer_name)."' WHERE `client_code`=" . $code;
    break;
    case 'guardCheck':
    $client_name = ValidateAndGet('name');
      return "SELECT 1 FROM `client_status` WHERE `validation_name`='".@mysql_real_escape_string($client_name)."' AND `client_code`=".$code;
    break;
    default:
      # code...
    break;
  }
}


function AddSerials($db_conn){
  $duplicateSqlErrorCode = 1062;
  $separator = "#";

  $values = ValidateAndGet('values');

  $prefix = ValidateAndGet('prefix');

  $serialsArr = explode($separator, $values);

  $affectedRows = 0;
  $duplicates = "";

  LogMessage("adding serials");

  foreach ($serialsArr as $serial) {

    $vname = $prefix . "-" . sprintf('%04X', mt_rand(0, 65535));

    $insertStmt = "INSERT INTO `client_status` (`file_deleted`, `file_not_found`, `file_path`, `name`, `status`, `client_code`, `validation_name`) VALUES (0, 0, '" . @mysql_real_escape_string('C:\\\\Program Files (x86)\\\\vMix\\\\vMix.lic') . "', '', 1, " . $serial . ", '" . @mysql_real_escape_string($vname) . "')";
    $result = @mysql_query($insertStmt, $db_conn);
    
    if(!$result){
      
      $errorNo = @mysql_errno($db_conn);
      
      if($errorNo == $duplicateSqlErrorCode){
          $duplicates = $duplicates . $serial . $separator;
      }
      else{
        ServerResponse(ERROR);
      }
    }
    else{
      $affectedRows += @mysql_affected_rows($db_conn);  
    }
  }

  ServerResponse(SUCCESS, "affectedRows=$affectedRows;duplicateValues=$duplicates");
}


if(isset($_POST['API_KEY']) && trim($_POST['API_KEY']) != ''){
   $apiKey = trim($_POST['API_KEY']);
};

if($_SERVER['HTTP_X_API_KEY'] === Token() || $apiKey === Token()){

  LogMessage("Valid token");

  $op = ValidateAndGet('op');

  LogMessage("Validating dbconn");

// connect to database
  $db_conn = @mysql_connect($db_host, $db_user, $db_pass);
  ValidateObj($db_conn);

  LogMessage("Validating db");

// select target database
  $db_selected = @mysql_select_db($db_name, $db_conn);
  ValidateObj($db_selected);

  LogMessage("Getting Sql");

  if($op == 'addSerials'){
    AddSerials($db_conn);
  }
  else{
    $sql = GetSql($op);

    LogMessage("Sql: " . $sql);

    // execute sql
    $result = @mysql_query($sql, $db_conn);

    LogMessage("After query");

    // get result set size
    if(@mysql_num_rows($result) == 0)
    {

      LogMessage("No rows");

      $affected_rows = @mysql_affected_rows($db_conn);

      @mysql_free_result($result);

      // insert or update case
      if($affected_rows > 0){
        ServerResponse(SUCCESS, "affectedRows=$affected_rows;");
      }

      ServerResponse(NOROWS);
    }
    else
    {
      $data_table = "";
      
      LogMessage("fetching result");

      // one row code
      $row = @mysql_fetch_array($result, MYSQL_NUM);  

      $num_columns = @mysql_num_fields ($result);

      LogMessage("Num cols: " . $num_columns);

      for ($i=0; $i < $num_columns; $i++) { 
        LogMessage("Getting field name: " . $i . "=" . $row[$i]);
        $data_table .= @mysql_field_name($result, $i) . "=" . $row[$i] . ";";
      }

    $data_table .= "\n";

    @mysql_free_result($result);

    ServerResponse(SUCCESS, $data_table);
    }
  }
}
else{
  LogMessage("Invalid token");
  ServerResponse(INVALIDTOKEN);
  die();
}

?>